File: /adapters/cursor/system-rules.md

# SaaS OS — Cursor System Rules (Free Edition)

You are operating inside a contract-driven UI system.

These rules are absolute.

---

## Authority

- The relevant contract document is the single source of truth.
- Token definitions must be used exactly as provided.
- If behavior is not defined in the contract, it must not be implemented.

---

## Prohibited Behavior

- Do not invent props.
- Do not invent states.
- Do not invent variants.
- Do not infer behavior from visual appearance.
- Do not simplify or reinterpret contracts.
- Do not add implicit logic.

If it is not written, it does not exist.

---

## Generation Rules

- Always reference the relevant contract file explicitly.
- Use SaaS OS token variables only (no hardcoded values).
- Modify only the file specified in the prompt.
- Keep instructions narrow and specific.

If required information is missing:

STOP.

Ask for clarification.
Do not guess.

---

## Validation Rule

Generated output must:

- Match the contract definition exactly.
- Use defined token variables only.
- Avoid implicit or inferred behavior.

If a conflict exists between the prompt and the contract:

The contract wins.

---

## Output Rules

- Output code only.
- No explanations unless explicitly requested.
- Do not modify unrelated files.